/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230509
* Description : PB口的输入改变中断，PB口的低优先级中断,通过PA1的翻转查看PB的低优先级中断是否产生，PA1翻转PB口产生中断,否则PB口未产生中断
* Note		  :
********************************************************************************/


/*********************************************************************************************
*
* _FINTOSC_DIV1   :  内部RC振荡器频率选择
* _DBG_OFF        :  DEBUG模式使能位
* _LVREN_OFF       :  禁止LVR
* _LVR24V         :  LVR的电压选择为2.4V
* _FLASH_CP1_OFF  :  1K~2K*16 FLASH CP保护
* _FLASH_CP0_OFF  :  0~1K*16 FLASH CP保护
* _IDIS_OFF	      :  模拟IO打开，数据读取控制位
* _CKSUM_OFF      :  校验使能位
* _CBP_OFF	      :  代码保护选择位
* _RESETE_OFF     :  外部复位使能
* _RSEL		      :  端口上下拉电阻选择
* _STV_ON		  :  堆栈溢出复位
* _PSUT_2		  :  上电复位时间选择
* _FCPU_4T        :  指令周期选择4T
* _WDTE_OFF       :  看门狗使能
* _TWDT_000       :  看门狗溢出时间选择
* _OSCM_HIRC_16M  :  系统时钟选择高速时钟
* _MTPDIS_OFF     :  SWD模式下读FALSH控制
* _ADCSP_ON	      :	 ADC采集速度选择
*

************************************************************************************************/
#include "AD18F08.h"

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                                        );




void main(void)
{
    TRISB    = 0xFF; //设置PB口为输入
    TRISA0   = 0; //设置PA0口为输出
    TRISA1   = 0; //设置PA1口为输出

    PAPU    = 0xFF; //关闭PA口的上拉
    PBPU    = 0xFF;	//关闭PB口的上拉

    PAPD    = 0xFF;//关闭PA口的下拉
    PBPD    = 0xFF;//关闭PB口的下拉

    PAOD    = 0x00; //关闭PA口的开漏
    PBOD    = 0x00; //关闭PB口的开漏

	GIEH  = 1;//使能高优先级总中断
    GIEL  = 1;//使能低优先级总中断
    IPEN  = 1;//高低优先级中断使能位
    PBIP  = 0;//PB口的低优先级使能位
    PBIE  = 1;//PB口的中断允许位，使能之后才可以进中断服务函数
    PBIF  = 0;//PB口的中断标志位

    PBINTMASK |=(1<<0); // 使能PB0的输入改变中断控制位
    PBINTMASK |=(1<<1); // 使能PB1的输入改变中断控制位
    PBINTMASK |=(1<<2); // 使能PB2的输入改变中断控制位
    PBINTMASK |=(1<<3); // 使能PB3的输入改变中断控制位
    PBINTMASK |=(1<<4); // 使能PB4的输入改变中断控制位
    PBINTMASK |=(1<<5); // 使能PB5的输入改变中断控制位
    PBINTMASK |=(1<<6); // 使能PB6的输入改变中断控制位
    PBINTMASK |=(1<<7); // 使能PB7的输入改变中断控制位
	while(1);

}
//高优先级中断服务函数
void interrupt ISR_h (void)
{

  unsigned char tmp_int;
  tmp_int=PIR2;
  if((tmp_int&0X40==0X40) && PBIE)
    {
        PBIF = 0;
        PA0  = ~PA0;//用于检测高优先级中断产生
    }
}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
  unsigned char tmp_int;  
  tmp_int=PIR2;
  if((tmp_int&0X40==0X40) && PBIE)
    {
        PBIF = 0;
        PA1  = ~PA1;//用于检测低优先级中断产生
    }

}
